package benchmarks;

import java.io.IOException;

import flexjson.JSONDeserializer;
import flexjson.JSONSerializer;

public class FlexJSONLib implements TestMethods {
	
	public JSONSerializer serializer;
	
	public FlexJSONLib() {
		serializer = new JSONSerializer();
	}

	@Override
	public byte[] serialize(Object o) throws IOException {
		return serializer.serialize(o).getBytes("UTF-8");
	}

	@Override
	public Object deserialize(byte[] b, Class c) throws IOException,
			ClassNotFoundException {
		return new JSONDeserializer<Object>().deserialize(new String(b, "UTF-8"), Object.class);
	}

	@Override
	public Object copy(Object o) throws IOException, ClassNotFoundException {
		return deserialize(serialize(o), o.getClass());
	}

}
